---
title: Browser Support
description: Check browser compatibility for Tabler.
summary: Learn about the supported browsers and compatibility guidelines for using Tabler UI components to ensure a consistent experience across different devices and platforms.
---

Tabler is fully optimized for all modern browsers, including the latest versions of Chrome, Firefox, Edge, Safari, and Opera. These browsers ensure a seamless and responsive experience, allowing users to enjoy Tabler's advanced UI components without compatibility issues.

In this latest release, Tabler introduces modern features like CSS Grid, object fit, and sticky positioning, which enhance design flexibility but may not be fully supported on older browsers. While Tabler has dropped most vendor prefixes to streamline its styles, partial support remains for Internet Explorer, with some features potentially limited.

For the best experience, we recommend using one of the latest supported browsers to take full advantage of Tabler’s capabilities and design precision.

## Supported Browsers

Browser|Version
---|----------
<img src="/img/browsers/edge.svg" width="48" height="48" alt="Edge Logo"/>|last 3 versions
<img src="/img/browsers/firefox.svg" width="48" height="48" alt="Firefox Logo"/>|last 3 versions, ESR
<img src="/img/browsers/chrome.svg" width="48" height="48" alt="Chrome Logo"/>|last 3 versions
<img src="/img/browsers/safari.svg" width="48" height="48" alt="Safari Logo"/>|last 3 versions
<img src="/img/browsers/opera.svg" width="48" height="48" alt="Opera Logo"/>|last 3 versions
<img src="/img/browsers/electron.svg" width="48" height="48" alt="Electron Logo"/>|last 3 versions
<img src="/img/browsers/brave.svg" width="48" height="48" alt="Brave Logo"/>|last 3 versions
<img src="/img/browsers/vivaldi.svg" width="48" height="48" alt="Vivaldi Logo"/>|last 3 versions

## Internet Explorer

Internet Explorer is not supported.